/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.PropertiesException;
import jade.util.leap.Properties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BasicProperties
extends Properties {
    boolean CRState = false;
    Hashtable keyNames = null;
    Vector sortVector = null;

    public static void main(String[] args) {
        BasicProperties prop = new BasicProperties(args);
        prop.list(System.out);
    }

    public BasicProperties() {
    }

    public BasicProperties(String[] theArgs) {
        this();
        this.parseArgs(theArgs);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.addFromReader(new InputStreamReader(inStream, "8859_1"));
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        OutputStreamWriter writer = new OutputStreamWriter(out, "8859_1");
        if (header != null) {
            writer.write("#" + header);
            writer.write(lineSeparator);
        }
        writer.write("#" + new Date().toString());
        writer.write(lineSeparator);
        Enumeration e = this.sortedKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object data = super.get(key);
            if (data == null) continue;
            writer.write(key + "=" + data.toString());
            writer.write(lineSeparator);
        }
        ((Writer)writer).flush();
    }

    public synchronized Enumeration sortedKeys() {
        if (this.sortVector == null) {
            this.sortVector = new Vector();
        } else {
            this.sortVector.removeAllElements();
        }
        Enumeration e = super.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            int i = 0;
            while (i < this.sortVector.size()) {
                if (key.compareTo((String)this.sortVector.elementAt(i)) < 0) break;
                ++i;
            }
            this.sortVector.insertElementAt(key, i);
        }
        return new Enumeration(){
            Enumeration en;
            {
                this.en = BasicProperties.this.sortVector.elements();
            }

            public boolean hasMoreElements() {
                return this.en.hasMoreElements();
            }

            public Object nextElement() {
                return this.en.nextElement();
            }
        };
    }

    public synchronized void parseArgs(String[] args) {
        if (args != null) {
            int argIndex = 0;
            String[] newArgs = this.prepareArgs(args);
            while (argIndex < newArgs.length) {
                String arg = newArgs[argIndex];
                this.parseArgument(arg);
                argIndex = this.nextArgIndex(newArgs, argIndex);
                if (argIndex >= 0 && argIndex < newArgs.length) continue;
                return;
            }
        }
    }

    protected void parseArgument(String arg) {
        if (this.isCandidate(arg)) {
            String value;
            String key = this.isolateKey(arg);
            if (this.storableProperty(key, value = this.isolateValue(arg))) {
                this.setProperty(key, value);
            }
        } else {
            this.specialHandling(arg);
        }
    }

    protected String[] prepareArgs(String[] args) {
        return args;
    }

    protected int getSeparatorIndex(String arg) {
        int idxA = arg.indexOf(61);
        int idxB = arg.indexOf(58);
        if (idxA == -1) {
            return idxB;
        }
        if (idxB == -1) {
            return idxA;
        }
        if (idxA < idxB) {
            return idxA;
        }
        return idxB;
    }

    protected boolean isCandidate(String arg) {
        if (this.getSeparatorIndex(arg) > 0) {
            return true;
        }
        return arg.length() > 1 && arg.startsWith("-");
    }

    protected void specialHandling(String arg) {
        throw new PropertiesException("Unrecognized: " + arg);
    }

    protected String isolateKey(String arg) {
        int separatorIndex = this.getSeparatorIndex(arg);
        if (separatorIndex > 0) {
            return arg.substring(0, separatorIndex);
        }
        if (arg.length() > 1 && arg.startsWith("-")) {
            return arg.substring(1);
        }
        throw new PropertiesException("Unable to identify key part in argument: " + arg);
    }

    protected String isolateValue(String arg) {
        String value = null;
        int separatorIndex = this.getSeparatorIndex(arg);
        if (separatorIndex > 0) {
            if (separatorIndex == arg.length() - 1) {
                return null;
            }
            value = arg.substring(separatorIndex + 1);
        } else if (arg.length() > 1 && arg.startsWith("-")) {
            value = "true";
        }
        if (value != null) {
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.length() == 2 ? "" : "\"" + value.substring(1, value.length() - 1) + "\"";
            }
            return value;
        }
        throw new PropertiesException("Unable to identify value part in argument: " + arg);
    }

    protected boolean storableProperty(String key, String value) {
        return true;
    }

    protected int nextArgIndex(String[] args, int argIndex) {
        return argIndex + 1;
    }

    public synchronized void copyProperties(BasicProperties source) {
        Enumeration e = ((Hashtable)source).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            super.put(key, source.getRawProperty(key));
        }
    }

    public synchronized BasicProperties extractSubset(String anArgPrefix) {
        BasicProperties result = new BasicProperties();
        Enumeration e = super.keys();
        while (e.hasMoreElements()) {
            String originalKey = (String)e.nextElement();
            String newKey = null;
            newKey = originalKey.startsWith(anArgPrefix) ? originalKey.substring(anArgPrefix.length()) : "";
            if (newKey.length() <= 0) continue;
            result.setProperty(newKey, this.getRawProperty(originalKey));
        }
        return result;
    }

    public Object get(String aKey) {
        String testKey;
        String string = testKey = aKey.endsWith("!") ? aKey.substring(0, aKey.length()) : aKey;
        if (testKey.length() == 0) {
            return null;
        }
        Object data = super.get(testKey);
        if (data == null) {
            data = super.get(testKey + "!");
        }
        return data;
    }

    public Object put(String aKey, Object aValue) {
        String testKey;
        String actualKey = this.doSubstitutions(aKey);
        String string = testKey = actualKey.endsWith("!") ? actualKey.substring(0, actualKey.length()) : actualKey;
        if (super.containsKey(testKey + "!")) {
            throw new PropertiesException("Attempt to alter read only property:" + testKey);
        }
        return super.put(actualKey, aValue);
    }

    public String getProperty(String aKey) {
        return this.getProperty(this.doSubstitutions(aKey), null);
    }

    public Object setProperty(String aKey, String aValue) {
        String testKey;
        String actualKey = this.doSubstitutions(aKey);
        String string = testKey = actualKey.endsWith("!") ? actualKey.substring(0, actualKey.length()) : actualKey;
        if (super.containsKey(testKey + "!")) {
            throw new PropertiesException("Attempt to alter read only property:" + testKey);
        }
        if (aValue == null) {
            return super.remove(actualKey);
        }
        return super.put(actualKey, aValue);
    }

    public Object setPropertyIfNot(String aKey, String value) {
        String current = this.getProperty(aKey);
        if (current == null) {
            return this.setProperty(aKey, value);
        }
        return current;
    }

    public String getRawProperty(String aKey) {
        Object data = super.get(aKey);
        return data != null ? data.toString() : null;
    }

    public String getPropertyIgnoreCase(String aKey) {
        Enumeration e = super.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!aKey.equalsIgnoreCase(key)) continue;
            return this.getProperty(key);
        }
        return null;
    }

    public String getProperty(String aKey, String defaultValue) {
        String value;
        String testKey;
        String string = testKey = aKey.endsWith("!") ? aKey.substring(0, aKey.length()) : aKey;
        if (testKey.length() == 0) {
            return null;
        }
        if (this.keyNames == null) {
            this.keyNames = new Hashtable();
        }
        if (this.keyNames.put(testKey, "x") != null) {
            throw new PropertiesException("Circular argument substitution with key: " + aKey);
        }
        Object data = super.get(testKey);
        if (data == null) {
            data = super.get(testKey + "!");
        }
        String string2 = value = data != null ? data.toString() : null;
        if (value != null) {
            if (value.length() >= 4) {
                value = this.doSubstitutions(value);
            }
        } else {
            value = defaultValue;
        }
        if (value != null) {
            value = this.valueFilter(aKey, value);
        }
        this.keyNames.remove(testKey);
        return value;
    }

    protected String valueFilter(String key, String value) {
        if (key.toLowerCase().indexOf("path") >= 0) {
            String correctSeparator = System.getProperty("path.separator");
            value = correctSeparator.equals(";") ? value.replace('|', ';') : value.replace('|', ':');
        }
        return value;
    }

    public int getIntProperty(String aKey, int aDefaultValue) {
        int result = aDefaultValue;
        try {
            result = Integer.parseInt(this.getProperty(aKey));
        }
        catch (Exception e) {}
        return result;
    }

    public int setIntProperty(String aKey, int aValue) {
        this.setProperty(aKey, Integer.toString(aValue));
        return aValue;
    }

    public boolean getBooleanProperty(String aKey, boolean aDefaultValue) {
        boolean result = aDefaultValue;
        try {
            String value = this.getProperty(aKey);
            result = value.equalsIgnoreCase("true");
        }
        catch (Exception e) {}
        return result;
    }

    public void setBooleanProperty(String aKey, boolean aValue) {
        this.setProperty(aKey, aValue ? "true" : "false");
    }

    public Object renameKey(String existingKey, String newKey) {
        Object value = super.remove(this.doSubstitutions(existingKey));
        if (value != null) {
            return super.put(this.doSubstitutions(newKey), value);
        }
        return null;
    }

    public String doSubstitutions(String anInputString) {
        return this.doSubstitutions(anInputString, false);
    }

    public String doSubstitutions(String anInputString, boolean allowUndefined) {
        if (anInputString == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int si = 0;
        int oi = 0;
        int ci = 0;
        do {
            oi = anInputString.indexOf("${", si);
            ci = anInputString.indexOf(125, si);
            if (oi > si) {
                result.append(anInputString.substring(si, oi));
                si = oi;
            }
            if (oi == si && ci > oi + 2) {
                String key = anInputString.substring(oi + 2, ci);
                String value = this.getProperty(key, null);
                if (value == null && key.equals(key.toUpperCase())) {
                    value = this.getEnvironmentProperty(key);
                }
                if (value == null) {
                    if (allowUndefined) {
                        value = "${" + key + "}";
                    } else {
                        throw new PropertiesException("Unable to get property value for key: " + key);
                    }
                }
                if (oi > si) {
                    result.append(anInputString.substring(si, oi));
                }
                result.append(value);
                si = ci + 1;
                continue;
            }
            if (oi == -1) {
                result.append(anInputString.substring(si, anInputString.length()));
                si = anInputString.length();
                continue;
            }
            result.append(anInputString.substring(si, oi + 2));
            si = oi + 2;
        } while (si < anInputString.length());
        return result.toString();
    }

    protected String getEnvironmentProperty(String key) {
        String value = System.getProperty(key.toLowerCase());
        return value;
    }

    protected void addFromReader(Reader reader) throws IOException {
        String line = null;
        Object key = null;
        Object value = null;
        do {
            if ((line = this.getOneLine(reader)) == null || (line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("!")) continue;
            this.parseArgument(line);
        } while (line != null);
    }

    protected String getOneLine(Reader reader) throws IOException {
        boolean continued;
        StringBuffer sb = null;
        String line = null;
        do {
            continued = false;
            try {
                line = this.readLine(reader);
                if (line == null) continue;
                line = line.trim();
                if (sb != null && (line.length() == 0 || line.startsWith("#") || line.startsWith("!"))) {
                    continued = true;
                    continue;
                }
                continued = line.endsWith("\\");
                if (continued) {
                    line = line.substring(0, line.length() - 1);
                }
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(line);
            }
            catch (EOFException eof) {
                continued = false;
            }
        } while (continued);
        return sb == null ? null : sb.toString();
    }

    protected String readLine(Reader aReader) throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean done = false;
        while (!done) {
            int result = aReader.read();
            if (result == -1) {
                if (sb.length() > 0) break;
                throw new EOFException();
            }
            char ch = (char)result;
            if (ch == '\n') {
                if (!this.CRState) break;
                this.CRState = false;
                continue;
            }
            if (ch == '\r') {
                this.CRState = true;
                break;
            }
            sb.append(ch);
            this.CRState = false;
        }
        return sb.toString();
    }

    public void list(PrintStream out) {
        Enumeration e = this.sortedKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            if (value != null) {
                out.println(key + "=" + value);
                continue;
            }
            out.println(key + "=");
        }
    }

    public String[] toStringArray() {
        String[] result = new String[super.size()];
        int i = 0;
        Enumeration e = this.sortedKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            result[i++] = value != null ? key + "=" + value : key + "=";
        }
        return result;
    }
}

